﻿screen say:

    default side_image = None
    default two_window = False

    if not two_window:
      
        window:
            id "window"

            has vbox:
                style "say_vbox"

            if who:
                text who id "who"

            text what id "what"

    else:

        vbox:
            style "say_two_window_vbox"

            if who:            
                window:
                    style "say_who_window"

                    text who:
                        id "who"
                        
            window:
                id "window"

                has vbox:
                    style "say_vbox"

                text what id "what"

    if side_image:
        add side_image
    else:
        add SideImage() xalign 0.0 yalign 1.0

    # Use the quick menu.
    use quick_menu

screen choice:

    window: 
        style "menu_window"        
        xalign 0.5
        yalign 0.5
        
        vbox:
            style "menu"
            spacing 2
            
            for caption, action, chosen in items:
                
                if action:  
                    
                    button:
                        action action
                        style "menu_choice_button"                        

                        text caption style "menu_choice"
                    
                else:
                    text caption style "menu_caption"

init -2 python:
    config.narrator_menu = True
    
    style.menu_window.set_parent(style.default)
    style.menu_choice.set_parent(style.button_text)
    style.menu_choice.clear()
    style.menu_choice_button.set_parent(style.button)
    style.menu_choice_button.xminimum = int(config.screen_width * 0.75)
    style.menu_choice_button.xmaximum = int(config.screen_width * 0.75)

screen input:

    window:
        has vbox

        text prompt
        input id "input"

    use quick_menu

screen nvl:

    window:
        style "nvl_window"

        has vbox:
            style "nvl_vbox"

        # Display dialogue.
        for who, what, who_id, what_id, window_id in dialogue:
            window:
                id window_id

                has hbox:
                    spacing 10

                if who is not None:
                    text who id who_id

                text what id what_id

        if items:

            vbox:
                id "menu"

                for caption, action, chosen in items:

                    if action:

                        button:
                            style "nvl_menu_choice_button"
                            action action

                            text caption style "nvl_menu_choice"

                    else:

                        text caption style "nvl_dialogue"

    add SideImage() xalign 0.0 yalign 1.0
    
    use quick_menu

screen main_menu:

    tag menu

    window:
        style "mm_root"

    frame:
        style_group "mm"
        xalign .98
        yalign .98

        has vbox

        textbutton _("Inizia") action Start()
        textbutton _("Preferenze") action ShowMenu("preferences")
        textbutton _("Carica") action ShowMenu("load")
        textbutton _("Aiuto") action Help()
        textbutton _("Esci") action Quit()

init -2 python:

    style.mm_button.size_group = "mm"

screen navigation:

    window:
        style "gm_root"

    frame:
        style_group "gm_nav"
        xalign .98
        yalign .98
        
        has vbox
        
        textbutton _("Indietro") action Return()
        textbutton _("Preferenze") action ShowMenu("preferences")
        textbutton _("Salva") action ShowMenu ("save")
        textbutton _("Carica") action ShowMenu("load")
        textbutton _("Aiuto") action Help()
        textbutton _("Menu Principale") action MainMenu()

init -2 python:
    style.gm_nav_button.size_group = "gm_nav"
    
screen file_picker:

    frame:
        style "file_picker_frame"

        has vbox

        hbox:
            style_group "file_picker_nav"

        $ columns = 1
        $ rows = 5
  
        grid columns rows:
            transpose True
            xfill True
            style_group "file_picker"

            for i in range(1, columns * rows + 1):

                button:
                    action FileAction(i)
                    xfill True

                    has hbox

                    add FileScreenshot(i)

                    $ description = "% 2s. %s\n%s                                                                                                                                                          " % (
                        FileSlotName(i, columns * rows),
                        FileTime(i, empty=_("Vuoto")),
                        FileSaveName(i))

                    text description
                    
                    button:
                      action FileDelete(i) 
                      text "Elimina"
                    
                    
screen save:

    tag menu

    use navigation
    use file_picker

screen load:

    tag menu

    use navigation
    use file_picker

init -2 python:
    style.file_picker_frame = Style(style.menu_frame)

    style.file_picker_nav_button = Style(style.small_button)
    style.file_picker_nav_button_text = Style(style.small_button_text)

    style.file_picker_button = Style(style.large_button)
    style.file_picker_text = Style(style.large_button_text)
    
screen preferences:

    tag menu

    # Include the navigation.
    use navigation

    grid 1 2:
        style_group "prefs"
        xfill True

        # The left column.
        vbox:
            frame:
                style_group "pref"
                has vbox

                label _("Visualizza")
                textbutton _("Finestra") action Preference("display", "window")
                textbutton _("Schermo Intero") action Preference("display", "fullscreen")

            frame:
                style_group "pref"
                has vbox

                label _("Velocità Testo")
                bar value Preference("text speed")

        vbox:
            frame:
                style_group "pref"
                has vbox

                label _("Volume Musica")
                bar value Preference("music volume")

            frame:
                style_group "pref"
                has vbox

                label _("Volume Suoni")
                bar value Preference("sound volume")

                if config.sample_sound:
                    textbutton "Test":
                        action Play("sound", config.sample_sound)
                        style "soundtest_button"

init -2 python:
    style.pref_frame.xfill = True
    style.pref_frame.xmargin = 5
    style.pref_frame.top_margin = 5

    style.pref_vbox.xfill = True

    style.pref_button.size_group = "pref"
    style.pref_button.xalign = 1.0

    style.pref_slider.xmaximum = 192
    style.pref_slider.xalign = 1.0

    style.soundtest_button.xalign = 1.0
    
screen yesno_prompt:

    modal True

    window:
        style "gm_root"

    frame:
        style_group "yesno"

        xfill True
        xmargin .05
        ypos .1
        yanchor 0
        ypadding .05
        
        has vbox:
            xalign .5
            yalign .5
            spacing 30
            
        label _(message):
            xalign 0.5

        hbox:
            xalign 0.5
            spacing 100
            
            textbutton _("Sì") action yes_action
            textbutton _("No") action no_action


init -2 python:    
    style.yesno_button.size_group = "yesno"
    style.yesno_label_text.text_align = 0.5

screen quick_menu:

    hbox:
        style_group "quick"
    
        xalign 1.0
        yalign 1.0

        textbutton _("Salva") action ShowMenu('save')
        textbutton _("Preferenze") action ShowMenu('preferences')
        textbutton _("Menu Principale") action MainMenu()
        
init -2 python:
    style.quick_button.set_parent('default')
    style.quick_button.background = None
    style.quick_button.xpadding = 5

    style.quick_button_text.set_parent('default')
    style.quick_button_text.size = 18
    style.quick_button_text.idle_color = "#8888"
    style.quick_button_text.hover_color = "#ccc"
    style.quick_button_text.selected_idle_color = "#cc08"
    style.quick_button_text.selected_hover_color = "#cc0"
    style.quick_button_text.insensitive_color = "#4448"

    config.default_afm_time = 10
    config.default_afm_enable = False
    
    layout.ARE_YOU_SURE = "Sei sicuro?"
    layout.QUIT = "Sei sicuro di voler uscire?"
    layout.MAIN_MENU = "Sei sicuro di voler tornare al menù principale? Perderai tutti i progressi non salvati."
    layout.DELETE_SAVE = "Sei sicuro di voler eliminare questo salvataggio?"
    layout.OVERWRITE_SAVE ="Sei sicuro di voler sovrascrivere questo salvataggio?"
    layout.LOADING = "Con questa azione perderai tutti i progressi non salvati. Sei sicuro di voler procedere?"
